#if !defined(AFX_resultdata_H__41507800_6F5D_11D2_8F2A_B6712CEBA7CD__INCLUDED_)
#define AFX_resultdata_H__41507800_6F5D_11D2_8F2A_B6712CEBA7CD__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "configdata.h"
#include "demodata.h"
#include "misc.h"
#include "error.h"
#include <string.h>
#include <stdio.h>
#include <io.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>

typedef struct player_t {
	char			name[65];
	char			shortname[65];
	char			shortname_4[5];
	int				lifetime_total;
	int				lifetime_average;
	int				lifetime_longest;
	int				lifetime_shortest;
	int				mkiol;
	int				clan;
	int				team;
	int				stats_color[3];
	int				quad_time;
	int				quad_kills;
	player_t*		next;
} player_t;

typedef struct map_t {
	char*			name;
	char*			file;
	int				seconds;
	map_t*			next;
} map_t;

typedef struct demo_t {
	char*			name;
	int				size;
	map_t*			maps;
	int				mapcount;
	int				seconds;
	demo_t*			next;
} demo_t;

class resultdata  
{
private:
	configdata*		config;
	error*			err;
	misc*			misc;
	int***			kills; // copied
	int**			player_total_kills; // copied
	int**			total_was_killed; // copied
	int**			deaths; // copied
	int*			extra_frags; // copied
	int*			total_kills;
	int*			flag_captures; // copied
	int*			ctf_assists; // copied
	int*			ctf_helped_return; // copied
	int*			flag_steals; // copied
	int*			flag_drops; // copied
	int*			flag_returns; // copied
	int*			ctf_defend_flag; // copied
	int*			ctf_defend_base; // copied
	int*			ctf_defend_flagcarrier; // copied
	int*			ctf_defend_aggressive; // copied
	int*			flagcarrier_frags; // copied
	bool			frozen;
	int				player_count;
	int				demo_count;
	int				total_time;
	player_t*		players;
	player_t*		first_player;
	player_t*		current_player;
	player_t*		last_player;
	demo_t*			first_demo;
	demo_t*			current_demo;
	demo_t*			last_demo;
	demo_t**		demos;
	void			parse_player_data();
	void			parse_demo_data();
	void			swap_players (int player1, int player2);
	void			init_data();
	void			get_player_clans();
	bool			exist_player(char* player);
	bool			calculated;
public:
	int get_player_memberkilled (int pnum, int weapon);
	int get_player_memberkills (int pnum, int weapon);
	int get_player_total_deaths (int pnum);
	int get_team_quadkills (int team);
	int get_team_quadtime (int team);
	int get_team_memberkills (int team);
	int get_team_total_deaths (int team);
	int get_quad_total_kills ();
	void calculate (configdata* in_config);
	int max_deaths (int type);
	int get_player_rank (int pnum, sort_t order);
	double get_max_player_dph();
	double get_max_player_kph();
	double get_max_player_fph();
	int get_max_player_deaths(int type);
	int get_max_player_suicides();
	int get_max_player_frags ();
	int get_max_player_total_kills ();
	int get_max_player_total_waskilled ();
	int get_max_player_lifetime_average ();
	int get_max_player_lifetime_longest ();
	int get_max_player_mkiol ();
	map_t*			last_map;
	demo_t* get_demo (int num);
	int get_player_flag_captures_score (int player);
	int get_player_ctf_score (int player);
	int get_player_ctf_defends (int player);
	int get_player_ctf_defends_score (int player);
	int get_team_ctf_defends (int team);
	int get_team_ctf_defends_score (int team);
	void set_player_count (int count);
	int get_team_ctf_score (int team);
	int get_team_member_count (int team);
	int get_team_deaths (int team);
	int get_team_suicides (int team);
	int get_team_killed (int team);
	int get_team_kills (int team);
	int get_team_frags (int team);
	resultdata();
	virtual ~resultdata();
	void			freeze(); // parse player and weapon data
	void			sort_players (sort_t order);
	void			delete_nullplayers();
	int				add_player(char* player); // if (!frozen)
	void			add_map (char* mapname, char* mapfile);
	void			add_demo (char* demoname, int demosize, int seconds);
	void			add_kill(int killer, int victim, int weapon); // if (frozen) 
	void			add_death(int player, int weapon); // if (frozen) 
	void			add_extra_frags(int player, int weapon); // if (frozen) 
	void			add_flag_capture(int player, int team);
	void			add_ctf_assist(int player, int team);
	void			add_ctf_helped_return(int player, int team);
	void			add_flag_steal(int player, int team);
	void			add_flag_loss(int player, int team);
	void			add_flag_return(int player, int team);
	void			add_ctf_defend_flag(int player, int team);
	void			add_ctf_defend_base(int player, int team);
	void			add_ctf_defend_flagcarrier(int player, int team);
	void			add_ctf_defend_aggressive(int player, int team);
	void			add_flagcarrier_frag(int player, int team);
	void			set_demo_count (int count);
	void			set_player_team (int player, int team);
	void			set_player_mkiol (int Player, int count); // if (frozen)
	void			set_total_time (int time);
	void			set_player_lifetime_total (int player, int lifetime);
	void			set_player_lifetime_average (int player, int lifetime);
	void			set_player_lifetime_longest (int player, int lifetime);
	void			set_player_lifetime_shortest (int player, int lifetime);
	int				get_demo_count();
	int				get_player_count ();
	int				get_player_number (char* name);
	player_t*		get_player(int num);
	int				get_player_kills (int killer, int victim, int weapon);
	int				get_player_suicides (int player, int weapon);
	int				get_player_frags (int killer);
	int				get_player_deaths (int player, int deathtype);
	int				get_total_deaths (int deathtype);
	int				get_player_total_kills (int killer, int weapon);
	int				get_player_total_waskilled (int killer, int weapon);
	int				get_total_kills (int weapon);
	int				get_player_extra_frags (int player);
	int				get_player_mkiol (int player);
	int				get_player_lifetime_total (int player);
	int				get_player_lifetime_average (int player);
	int				get_player_lifetime_longest (int player);
	int				get_player_lifetime_shortest (int player);
	int				get_total_time ();
	float			get_player_ratio (int pnum);
	float			get_player_skill (int pnum);
	float			get_player_fph (int pnum);
	float			get_player_kph(int pnum);
	float			get_player_dph (int pnum);
	int				get_player_worst_enemy (int pnum);
	int				get_player_easiest_prey (int pnum);
	int				get_player_favourite_weapon (short pnum);
	int				get_favourite_weapon ();
	int				get_team_flagcarrier_frags (int team);
	int				get_team_flag_returns (int team);
	int				get_team_ctf_defend_flag (int team);
	int				get_team_ctf_defend_base (int team);
	int				get_team_ctf_defend_flagcarrier (int team);
	int				get_team_ctf_defend_aggressive (int team);
	int				get_team_flag_steals (int team);
	int				get_team_flag_drops (int team);
	int				get_team_flag_captures(int team);
	int				get_team_ctf_assists(int team);
	int				get_team_ctf_helped_return(int team);
	int				get_player_flag_captures (int player);
	int				get_player_ctf_assists (int player);
	int				get_player_ctf_helped_return (int player);
	int				get_player_flag_steals (int player);
	int				get_player_flag_drops (int player);
	int				get_player_flag_returns (int player);
	int				get_player_ctf_defend_flag (int player);
	int				get_player_ctf_defend_base (int player);
	int				get_player_ctf_defend_flagcarrier (int player);
	int				get_player_ctf_defend_aggressive (int player);
	int				get_player_flagcarrier_frags (int player);
	int				get_clan_memberkills(int clan);
	int				get_clan_deaths (int clan);
	int				get_clan_suicides (int clan);
	int				get_clan_kills (int clan);
	int				get_clan_frags (int clan);
};

#endif // !defined(AFX_resultdata_H__41507800_6F5D_11D2_8F2A_B6712CEBA7CD__INCLUDED_)
